/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.model;

import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.contentassist.model.Messages;
import com.aptana.index.core.Index;
import com.aptana.index.core.ui.views.IPropertyInformation;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLElement
extends BaseElement<Property> {
    private Index index;

    public HTMLElement(Index index) {
        this.index = index;
        this.setName(Messages.HTMLElement_HTMLElementName);
    }

    public Index getIndex() {
        return this.index;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<HTMLElement>
    {
        NAME(Messages.HTMLElement_NameLabel){

            public Object getPropertyValue(HTMLElement node) {
                return node.getName();
            }
        }
        ,
        INDEX(Messages.HTMLElement_IndexLabel){

            public Object getPropertyValue(HTMLElement node) {
                return node.getIndex().toString();
            }
        }
        ,
        INDEX_FILE(Messages.HTMLElement_IndexFileLabel){

            public Object getPropertyValue(HTMLElement node) {
                return node.getIndex().getIndexFile().getAbsolutePath();
            }
        }
        ,
        INDEX_FILE_SIZE(Messages.HTMLElement_IndexFileSizeLabel){

            public Object getPropertyValue(HTMLElement node) {
                return node.getIndex().getIndexFile().length();
            }
        }
        ,
        CHILD_COUNT(Messages.HTMLElement_ChildCountLabel){

            public Object getPropertyValue(HTMLElement node) {
                return 2;
            }
        }
        ,
        VERSION(Messages.HTMLElement_VersionLabel){

            public Object getPropertyValue(HTMLElement node) {
                return 0.14;
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

